/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.client.render.entity.model;

import com.faboslav.friendsandfoes.client.render.entity.animation.ModelAnimator;
import com.faboslav.friendsandfoes.client.render.entity.model.BaseEntityModel;
import com.faboslav.friendsandfoes.mixin.ModelPartAccessor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AnimatedEntityModel<E extends Entity>
extends BaseEntityModel<E> {
    protected final ModelAnimator modelAnimator;
    protected final Map<String, PartPose> defaultModelTransforms = new HashMap<String, PartPose>();

    protected AnimatedEntityModel(ModelPart root) {
        super(root);
        this.setCurrentModelTransforms("root", this.root);
        this.modelAnimator = new ModelAnimator();
    }

    protected void setCurrentModelTransforms(String modelPartName, ModelPart modelPart) {
        this.defaultModelTransforms.put(modelPartName, modelPart.m_171308_());
        ModelPartAccessor modelPartAccessor = (ModelPartAccessor)modelPart;
        modelPartAccessor.getChildren().forEach(this::setCurrentModelTransforms);
    }

    protected void applyModelTransforms(String modelPartName, ModelPart modelPart) {
        PartPose defaultModelTransform = this.defaultModelTransforms.get(modelPartName);
        modelPart.m_171322_(defaultModelTransform);
        ModelPartAccessor modelPartAccessor = (ModelPartAccessor)modelPart;
        modelPartAccessor.getChildren().forEach(this::applyModelTransforms);
    }
}

